import {Slider} from '../src/Slider';

import type {Meta, StoryFn} from '@storybook/react';

const meta: Meta<typeof Slider> = {
  component: Slider,
  parameters: {
    layout: 'centered'
  },
  tags: ['autodocs']
};

export default meta;

type Story = StoryFn<typeof Slider>;

export const Example: Story = (args) => <Slider {...args} style={{width: 200}} />;

Example.args = {
  label: 'Range',
  defaultValue: [30, 60],
  thumbLabels: ['start', 'end']
};
